/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.trender.gui.widget;

import dev.tr7zw.trender.gui.client.BackgroundPainter;
import dev.tr7zw.trender.gui.client.RenderContext;
import dev.tr7zw.trender.gui.client.ScreenDrawing;
import dev.tr7zw.trender.gui.impl.client.style.WidgetTextures;
import dev.tr7zw.trender.gui.widget.WAbstractIntSlider;
import dev.tr7zw.trender.gui.widget.data.Axis;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class WSlider
extends WAbstractIntSlider {
    public static final int TRACK_WIDTH = 6;
    public static final int THUMB_SIZE = 8;
    @Nullable
    private BackgroundPainter backgroundPainter;

    public WSlider(int min, int max, Axis axis) {
        super(min, max, axis);
    }

    @Override
    protected int getThumbWidth() {
        return 8;
    }

    @Override
    protected boolean isMouseInsideBounds(int x, int y) {
        int ao = this.axis == Axis.HORIZONTAL ? y : x;
        int aoCenter = (this.axis == Axis.HORIZONTAL ? this.getHeight() : this.getWidth()) / 2;
        return ao >= aoCenter - 3 - 2 && ao <= aoCenter + 3 + 2;
    }

    @Override
    public void paint(RenderContext context, int x, int y, int mouseX, int mouseY) {
        if (this.backgroundPainter != null) {
            this.backgroundPainter.paintBackground(context, x, y, this);
        } else {
            int thumbXOffset;
            int thumbY;
            int thumbX;
            float px = 0.03125f;
            class_2960 texture = WidgetTextures.getSliderTextures().get();
            if (this.axis == Axis.VERTICAL) {
                int trackX = x + this.getWidth() / 2 - 3;
                thumbX = this.getWidth() / 2 - 4;
                thumbY = this.direction == WAbstractIntSlider.Direction.UP ? this.getHeight() - 8 + 1 - (int)(this.coordToValueRatio * (float)(this.value - this.min)) : Math.round(this.coordToValueRatio * (float)(this.value - this.min));
                thumbXOffset = 0;
                ScreenDrawing.texturedRect(context, trackX, y + 1, 6, 1, texture, 16.0f * px, 0.0f * px, 22.0f * px, 1.0f * px, -1);
                ScreenDrawing.texturedRect(context, trackX, y + 2, 6, this.getHeight() - 2, texture, 16.0f * px, 1.0f * px, 22.0f * px, 2.0f * px, -1);
                ScreenDrawing.texturedRect(context, trackX, y + this.getHeight(), 6, 1, texture, 16.0f * px, 2.0f * px, 22.0f * px, 3.0f * px, -1);
            } else {
                int trackY = y + this.getHeight() / 2 - 3;
                thumbX = this.direction == WAbstractIntSlider.Direction.LEFT ? this.getWidth() - 8 - (int)(this.coordToValueRatio * (float)(this.value - this.min)) : Math.round(this.coordToValueRatio * (float)(this.value - this.min));
                thumbY = this.getHeight() / 2 - 4;
                thumbXOffset = 8;
                ScreenDrawing.texturedRect(context, x, trackY, 1, 6, texture, 16.0f * px, 3.0f * px, 17.0f * px, 9.0f * px, -1);
                ScreenDrawing.texturedRect(context, x + 1, trackY, this.getWidth() - 2, 6, texture, 17.0f * px, 3.0f * px, 18.0f * px, 9.0f * px, -1);
                ScreenDrawing.texturedRect(context, x + this.getWidth() - 1, trackY, 1, 6, texture, 18.0f * px, 3.0f * px, 19.0f * px, 9.0f * px, -1);
            }
            int thumbState = this.dragging ? 1 : (mouseX >= thumbX && mouseX <= thumbX + 8 && mouseY >= thumbY && mouseY <= thumbY + 8 ? 2 : 0);
            ScreenDrawing.texturedRect(context, x + thumbX, y + thumbY, 8, 8, texture, (float)thumbXOffset * px, 0.0f * px + (float)(thumbState * 8) * px, (float)(thumbXOffset + 8) * px, 8.0f * px + (float)(thumbState * 8) * px, -1);
            if (thumbState == 0 && this.isFocused()) {
                ScreenDrawing.texturedRect(context, x + thumbX, y + thumbY, 8, 8, texture, 0.0f * px, 24.0f * px, 8.0f * px, 32.0f * px, -1);
            }
        }
    }

    @Nullable
    public BackgroundPainter getBackgroundPainter() {
        return this.backgroundPainter;
    }

    public void setBackgroundPainter(@Nullable BackgroundPainter backgroundPainter) {
        this.backgroundPainter = backgroundPainter;
    }
}

